import { NextResponse } from 'next/server'
import { db } from '@/lib/db'

export async function GET() {
  try {
    const [guruCount, siswaCount, kelasCount, mapelCount] = await Promise.all([
      db.guru.count(),
      db.siswa.count(),
      db.kelas.count(),
      db.mapel.count()
    ])

    return NextResponse.json({
      success: true,
      stats: {
        guru: guruCount,
        siswa: siswaCount,
        kelas: kelasCount,
        mapel: mapelCount
      }
    })
  } catch (error) {
    console.error('Get stats error:', error)
    return NextResponse.json(
      { error: 'Terjadi kesalahan saat mengambil statistik' },
      { status: 500 }
    )
  }
}
