import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'

// GET - Ambil semua data mapel
export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const search = searchParams.get('search')

    const mapelList = await db.mapel.findMany({
      where: search
        ? {
            OR: [
              { namaMapel: { contains: search } },
              { kodeMapel: { contains: search } },
              { kelompokMapel: { contains: search } }
            ]
          }
        : undefined,
      orderBy: { kodeMapel: 'asc' }
    })

    return NextResponse.json({ success: true, data: mapelList })
  } catch (error) {
    console.error('Get mapel error:', error)
    return NextResponse.json(
      { error: 'Terjadi kesalahan saat mengambil data mapel' },
      { status: 500 }
    )
  }
}

// POST - Tambah mapel baru
export async function POST(request: NextRequest) {
  try {
    const body = await request.json()
    const { kodeMapel, namaMapel, kelompokMapel, keterangan } = body

    if (!kodeMapel || !namaMapel) {
      return NextResponse.json(
        { error: 'Kode mapel dan nama mapel harus diisi' },
        { status: 400 }
      )
    }

    const mapel = await db.mapel.create({
      data: {
        kodeMapel,
        namaMapel,
        kelompokMapel,
        keterangan
      }
    })

    return NextResponse.json({ success: true, data: mapel }, { status: 201 })
  } catch (error) {
    console.error('Create mapel error:', error)
    return NextResponse.json(
      { error: 'Terjadi kesalahan saat menambah mapel' },
      { status: 500 }
    )
  }
}
