import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'
import bcrypt from 'bcryptjs'

// API ini hanya untuk development/testing
// Pastikan untuk menghapus atau mengamankannya di production
export async function POST(request: NextRequest) {
  try {
    // Cek apakah user admin sudah ada
    const existingAdmin = await db.user.findUnique({
      where: { username: 'admin' }
    })

    if (existingAdmin) {
      return NextResponse.json({
        success: true,
        message: 'Admin user already exists'
      })
    }

    // Hash password
    const hashedPassword = await bcrypt.hash('admin123', 10)

    // Buat user admin
    const admin = await db.user.create({
      data: {
        username: 'admin',
        password: hashedPassword,
        name: 'Administrator',
        role: 'admin'
      }
    })

    return NextResponse.json({
      success: true,
      message: 'Admin user created successfully',
      user: {
        id: admin.id,
        username: admin.username,
        name: admin.name,
        role: admin.role
      }
    })
  } catch (error) {
    console.error('Seed error:', error)
    return NextResponse.json(
      { error: 'Terjadi kesalahan saat seeding' },
      { status: 500 }
    )
  }
}
