import { db } from '../src/lib/db'
import bcrypt from 'bcryptjs'

async function main() {
  console.log('🌱 Seeding database...')

  // Seed User Admin
  console.log('📝 Seeding users...')
  const hashedPassword = await bcrypt.hash('admin123', 10)

  const admin = await db.user.upsert({
    where: { username: 'admin' },
    update: {},
    create: {
      username: 'admin',
      password: hashedPassword,
      name: 'Administrator',
      role: 'admin'
    }
  })
  console.log(`✅ User admin created: ${admin.username}`)

  // Seed Kelas
  console.log('📝 Seeding kelas...')
  const kelasData = [
    { kodeKelas: 'X-IPA-1', namaKelas: 'X IPA 1', waliKelas: 'Dr. Siti Aminah', keterangan: 'Kelas unggulan' },
    { kodeKelas: 'X-IPA-2', namaKelas: 'X IPA 2', waliKelas: 'Budi Santoso, S.Pd', keterangan: 'Kelas reguler' },
    { kodeKelas: 'X-IPS-1', namaKelas: 'X IPS 1', waliKelas: 'Ratna Sari, S.Pd', keterangan: 'Kelas reguler' },
    { kodeKelas: 'XI-IPA-1', namaKelas: 'XI IPA 1', waliKelas: 'Agus Setiawan, S.Pd', keterangan: 'Kelas unggulan' },
    { kodeKelas: 'XI-IPS-1', namaKelas: 'XI IPS 1', waliKelas: 'Dewi Kartika, S.Pd', keterangan: 'Kelas reguler' },
    { kodeKelas: 'XII-IPA-1', namaKelas: 'XII IPA 1', waliKelas: 'Eko Prasetyo, M.Pd', keterangan: 'Kelas ujian' },
  ]

  for (const k of kelasData) {
    await db.kelas.upsert({
      where: { kodeKelas: k.kodeKelas },
      update: {},
      create: k
    })
  }
  console.log(`✅ Created ${kelasData.length} kelas`)

  // Seed Mapel
  console.log('📝 Seeding mapel...')
  const mapelData = [
    { kodeMapel: 'MAT', namaMapel: 'Matematika', kelompokMapel: 'MIPA', keterangan: '' },
    { kodeMapel: 'BIN', namaMapel: 'Bahasa Indonesia', kelompokMapel: 'Bahasa', keterangan: '' },
    { kodeMapel: 'BIG', namaMapel: 'Bahasa Inggris', kelompokMapel: 'Bahasa', keterangan: '' },
    { kodeMapel: 'IPA', namaMapel: 'Ilmu Pengetahuan Alam', kelompokMapel: 'MIPA', keterangan: '' },
    { kodeMapel: 'IPS', namaMapel: 'Ilmu Pengetahuan Sosial', kelompokMapel: 'IPS', keterangan: '' },
    { kodeMapel: 'PJOK', namaMapel: 'Pendidikan Jasmani', kelompokMapel: 'Umum', keterangan: '' },
    { kodeMapel: 'PAI', namaMapel: 'Pendidikan Agama Islam', kelompokMapel: 'Umum', keterangan: '' },
    { kodeMapel: 'SEN', namaMapel: 'Seni Budaya', kelompokMapel: 'Umum', keterangan: '' },
  ]

  for (const m of mapelData) {
    await db.mapel.upsert({
      where: { kodeMapel: m.kodeMapel },
      update: {},
      create: m
    })
  }
  console.log(`✅ Created ${mapelData.length} mapel`)

  // Seed Guru
  console.log('📝 Seeding guru...')
  const guruData = [
    { nip: '198001012010011001', nama: 'Dr. Siti Aminah', mataPelajaran: 'Bahasa Indonesia', kontak: '081234567890', alamat: 'Jl. Merdeka No. 10' },
    { nip: '198502022015022001', nama: 'Budi Santoso, S.Pd', mataPelajaran: 'Matematika', kontak: '081234567891', alamat: 'Jl. Pahlawan No. 15' },
    { nip: '199003032019033001', nama: 'Ratna Sari, S.Pd', mataPelajaran: 'Ilmu Pengetahuan Alam', kontak: '081234567892', alamat: 'Jl. Sudirman No. 20' },
    { nip: '198804042013044001', nama: 'Agus Setiawan, S.Pd', mataPelajaran: 'Bahasa Inggris', kontak: '081234567893', alamat: 'Jl. Gatot Subroto No. 25' },
    { nip: '199205052018055001', nama: 'Dewi Kartika, S.Pd', mataPelajaran: 'Ilmu Pengetahuan Sosial', kontak: '081234567894', alamat: 'Jl. Diponegoro No. 30' },
    { nip: '198706062012066001', nama: 'Eko Prasetyo, M.Pd', mataPelajaran: 'Pendidikan Agama Islam', kontak: '081234567895', alamat: 'Jl. Ahmad Yani No. 35' },
  ]

  for (const g of guruData) {
    await db.guru.upsert({
      where: { nip: g.nip || '' },
      update: {},
      create: g
    })
  }
  console.log(`✅ Created ${guruData.length} guru`)

  // Seed Siswa
  console.log('📝 Seeding siswa...')
  const siswaData = [
    {
      induk: '2024001',
      nisn: '1234567890',
      tahunMasuk: '2024',
      nisLokal: '24001',
      nama: 'Ahmad Rizky',
      jenisKelamin: 'L',
      nik: '3201010101010001',
      nomorKk: '320101010101000001',
      agama: 'Islam',
      tempatLahir: 'Jakarta',
      tanggalLahir: '2008-05-15',
      anakKe: '1',
      statusKeluarga: 'Anak kandung',
      telepon: '081299990001',
      alamat: 'Jl. Mawar No. 10, Jakarta',
      kelas: 'X-IPA-1',
      statusSiswa: 'aktif',
      namaAyah: 'H. Ahmad Syafiq',
      nikAyah: '3201010101010002',
      ttlAyah: 'Jakarta, 15 Mei 1975',
      pendidikanAyah: 'S1',
      pekerjaanAyah: 'Wiraswasta',
      penghasilanAyah: '> 5 Juta',
      namaIbu: 'Hj. Siti Aisyah',
      nikIbu: '3201010101010003',
      ttlIbu: 'Bandung, 20 Agustus 1980',
      pendidikanIbu: 'S1',
      pekerjaanIbu: 'PNS',
      penghasilanIbu: '3-5 Juta',
      alamatOrtu: 'Jl. Mawar No. 10, Jakarta'
    },
    {
      induk: '2024002',
      nisn: '1234567891',
      tahunMasuk: '2024',
      nisLokal: '24002',
      nama: 'Putri Ayu',
      jenisKelamin: 'P',
      nik: '3201010101010004',
      nomorKk: '320101010101000002',
      agama: 'Islam',
      tempatLahir: 'Bandung',
      tanggalLahir: '2008-08-20',
      anakKe: '2',
      statusKeluarga: 'Anak kandung',
      telepon: '081299990002',
      alamat: 'Jl. Melati No. 15, Bandung',
      kelas: 'X-IPA-2',
      statusSiswa: 'aktif',
      namaAyah: 'Drs. Budi Santoso',
      nikAyah: '3201010101010005',
      ttlAyah: 'Surabaya, 10 Januari 1978',
      pendidikanAyah: 'S2',
      pekerjaanAyah: 'PNS',
      penghasilanAyah: '3-5 Juta',
      namaIbu: 'Dra. Ratna Sari',
      nikIbu: '3201010101010006',
      ttlIbu: 'Jakarta, 5 Maret 1982',
      pendidikanIbu: 'S1',
      pekerjaanIbu: 'Guru',
      penghasilanIbu: '1-3 Juta',
      alamatOrtu: 'Jl. Melati No. 15, Bandung'
    },
  ]

  for (const s of siswaData) {
    await db.siswa.upsert({
      where: { induk: s.induk },
      update: {},
      create: s
    })
  }
  console.log(`✅ Created ${siswaData.length} siswa`)

  console.log('🎉 Seeding completed successfully!')
  console.log('Login dengan:')
  console.log('  Username: admin')
  console.log('  Password: admin123')
}

main()
  .catch((e) => {
    console.error('❌ Seeding error:', e)
    process.exit(1)
  })
  .finally(async () => {
    await db.$disconnect()
  })
